﻿using System.IO;
using System.Xaml;

namespace XamlReadersAndWriters
{
    partial class Utils
    {
        public static object ConvertXmlStringToObjectGraph_Revised(string xmlString)
        {
            // String -> TextReader -> XamlXmlReader
            using (TextReader textReader = new StringReader(xmlString))
            using (XamlXmlReader reader = new XamlXmlReader(textReader,
            System.Windows.Markup.XamlReader.GetWpfSchemaContext()))
            using (XamlObjectWriter writer = new XamlObjectWriter(reader.SchemaContext))
            {
                // Pętla węzłowa
                XamlServices.Transform(reader, writer);
                // Kiedy XamlObjectWriter skończy, będzie to instancja obiektu głównego
                return writer.Result;
            }
        }
    }
}